//------------------------------------------------------------------------------
// File: svr_cmdhud.cs
// This file contains client-sent messages for the purpose of saving
// and loading command information that is only on the client side.
// Author: Michael Felice
//------------------------------------------------------------------------------

// this function is called when a gunslinger is recruited
function serverCmdRecruitGunslinger(%client, %ghostIDer, %index, %ghostIDee)
{
   %object = %client.resolveObjectFromGhostIndex(%ghostIDer);
   %target = %client.resolveObjectFromGhostIndex(%ghostIDee);
   %object.recruitedSlinger[%index] = %target;
   
   // update the recruit button index list
   if (%object.slingerMinIndex $= "")
   {
      %object.slingerMinIndex = %index;
      %object.slingerMaxIndex = %index + 1;
   }
   else if (%index < %object.slingerMinIndex)
   {
      %object.slingerMinIndex = %index;
   }
   else if (%index >= %object.slingerMaxIndex)
   {
      %object.slingerMaxIndex = %index + 1;
   }
}

// this function is called when a gunslinger that ws recruited
// no longer exists
function serverCmdClearGunslinger(%client, %ghostID, %index)
{
   %object = %client.resolveObjectFromGhostIndex(%ghostID);
   %object.recruitedSlinger[%index] = "";
}

// this function is called when a deputy is recruited
function serverCmdRecruitDeputy(%client, %ghostIDer, %index, %ghostIDee)
{
   %object = %client.resolveObjectFromGhostIndex(%ghostIDer);
   %target = %client.resolveObjectFromGhostIndex(%ghostIDee);
   %object.recruitedDeputy[%index] = %target;
}

// this function is called when a deputy that was recruited
// no longer exists
function serverCmdClearDeputy(%client, %ghostID, %index)
{
   %object = %client.resolveObjectFromGhostIndex(%ghostID);
   %object.recruitedDeputy[%index] = "";
   for (%i = %index; %i < $CS_MAXDEPUTIES - 1; %i++)
   {
      %object.recruitedDeputy[%i] = %object.recruitedDeputy[%i + 1];
      %object.recruitedDeputy[%i + 1] = "";
   }
}

// this function is called when a sheriff that was recruited
// no longer exists
function serverCmdClearSheriff(%client, %ghostID)
{
   %object = %client.resolveObjectFromGhostIndex(%ghostID);
   %object.recruitedSheriff = "";
}
